
IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='STONE_BANKING_TITULO_DDA')
BEGIN
	CREATE TABLE [STONE_BANKING_TITULO_DDA]
	(
		[CD_TITULO]				INT	IDENTITY(1,1)	NOT NULL,
		[ID_TITULO]				VARCHAR(50)		NOT NULL,
		[ID_CONTA_STONE]		VARCHAR(50)		NOT NULL,
		[CD_BARRAS]				VARCHAR(50)		NOT NULL,
		[LINHA_DIGITAVEL]		VARCHAR(50)		NOT NULL,
		[CD_STATUS]				INT				NOT NULL,
		[SITUACAO]				VARCHAR(50)			NULL, --VALIDAR
		[DT_VENCIMENTO]			DATETIME		NOT NULL,
		[VLR_TITULO]			MONEY			NOT NULL,
		[BENEFICIARIO_CNPJ]		VARCHAR(20)		NOT NULL,
		[BENEFICIARIO_NOME]		VARCHAR(150)	NOT NULL,
		[SACADO_CNPJ]			VARCHAR(20)		NOT NULL,
		[SACADO_NOME]			VARCHAR(150)	NOT NULL,
		[DT_LIMITE_PAGAMENTO]	DATETIME		NOT NULL,
		[JUROS_PERC]			DECIMAL				NULL,
		[DT_JUROS]				DATETIME			NULL,
		[MULTA_PERC]			DECIMAL				NULL,
		[DT_MULTA]				DATETIME			NULL,
		[PERC_DESC1]			DECIMAL				NULL,
		[DT_DESC1]				DATETIME			NULL,
		[PERC_DESC2]			DECIMAL				NULL,
		[DT_DESC2]				DATETIME			NULL,
		[PERC_DESC3]			DECIMAL				NULL,
		[DT_DESC3]				DATETIME			NULL,
		[DT_CADASTRO]			DATETIME		NOT NULL,
		[CD_USU]				INT				NOT NULL,

		CONSTRAINT [PK_STONE_BANKING_TITULO_DDA] PRIMARY KEY ([CD_TITULO])
		,CONSTRAINT [UC_STONE_BANKING_TITULO_DDA_ID_TITULO] UNIQUE (ID_TITULO)
		--, CONSTRAINT [FK_DDA_STONE_BANKING_TITULO_PG_CRED_PGTO_STONE_STATUS] FOREIGN KEY ([CD_STATUS]) REFERENCES [PG_CRED_PGTO_STONE_STATUS] ([CD_STATUS])
	)
END;
